/*
 * @(#)ClassListener.java  1.1  2010-06-26
 *
 * Copyright (c) 2003 Lucerne University of Applied Sciences and Arts (HSLU)
 * Zentralstrasse 18, Postfach 2858, CH-6002 Lucerne, Switzerland
 * All rights reserved.
 *
 * The copyright of this software is owned by the Lucerne University of Applied 
 * Sciences and Arts (HSLU). You may not use, copy or modify this software, 
 * except in accordance with the license agreement you entered into with HSLU. 
 * For details see accompanying license terms. 
 */


package ch.hslu.cm.oo.objectmodel;

import java.util.*;
/**
 * Listener interface for {@link OMClassEvent}.
 *
 * @author  Werner Randelshofer
 * @version 1.1 2010-06-26 Method abstractChanged added.
 * <br>1.0 30. Januar 2004  Created.
 */
public interface OMClassListener extends EventListener {
    public void attributeAdded(OMClassEvent event);
    public void attributeRemoved(OMClassEvent event);
    public void attributeChanged(OMClassEvent event);
    
    public void operationAdded(OMClassEvent event);
    public void operationRemoved(OMClassEvent event);
    public void operationChanged(OMClassEvent event);
    
    public void nameChanged(OMClassEvent event);
    public void abstractChanged(OMClassEvent event);
    public void generalizationChanged(OMClassEvent event);
}
